package si.lj.uni.fmf.pro2.lectures.pacmans;

/**
 * Class representing position in the Cartesian coordinate plane.
 * 
 * The position is represented by its horizontal and vertical coordinates.
 * 
 * @author Lovro Šubelj
 */
public class Position {
	
	/**
	 * Horizontal coordinate or abscissa of the position.
	 */
	private int x;
	
	/**
	 * Vertical coordinate or ordinate of the position.
	 */
	private int y;

	/**
	 * Constructs position in the Cartesian coordinate plane represented by its horizontal and vertical coordinates.
	 * 
	 * @param x horizontal coordinate or abscissa
	 * @param y vertical coordinate or ordinate
	 */
	public Position(int x, int y) {
		this.x = x;
		this.y = y;
	}

	/**
	 * Returns horizontal coordinate of the position in the Cartesian coordinate plane.
	 * 
	 * @return horizontal coordinate or abscissa
	 */
	public int getX() {
		return x;
	}

	/**
	 * Returns vertical coordinate of the position in the Cartesian coordinate plane.
	 * 
	 * @return vertical coordinate or ordinate
	 */
	public int getY() {
		return y;
	}

	/**
	 * Returns new position in the Cartesian coordinate plane moved by the specified point.
	 * 
	 * @param x horizontal coordinate or abscissa of the point
	 * @param y vertical coordinate or ordinate of the point
	 * 
	 * @return position moved by the horizontal and vertical coordinates of the specified point
	 */
	public Position move(int x, int y) {
		return new Position(getX() + x, getY() + y);
	}
	
	/**
	 * Computes Euclidean distance between the position in the Cartesian coordinate plane and the specified point.
	 * 
	 * @param x horizontal coordinate or abscissa of the point
	 * @param y vertical coordinate or ordinate of the point
	 * 
	 * @return Euclidean distance between the position and the specified point
	 */
	public double distance(int x, int y) {
		return Math.sqrt(Math.pow(getX() - x, 2.0) + Math.pow(getY() - y, 2.0));
	}
	
	/**
	 * Returns random unoccupied position in the Cartesian coordinate plane corresponding to the specified {@link Board}.
	 * 
	 * The function ensures that the returned position is unoccupied or empty tested by whether {@link Board#getCell(Position)} returns {@code null}.
	 * 
	 * @param board {@link Board} representing the Cartesian coordinate plane
	 * 
	 * @return random position in the Cartesian coordinate plane corresponding to the specified {@link Board} 
	 */
	public static Position random(Board board) {
		Position position = new Position((int)(Math.random() * board.getWidth()), (int)(Math.random() * board.getHeight()));
		while (board.getCell(position) != null)
			position = new Position((int)(Math.random() * board.getWidth()), (int)(Math.random() * board.getHeight()));
		
		return position;
	}
	
}