package si.lj.uni.fmf.pro2.lectures.pacmans;

/**
 * Class representing a small {@link Coin} on a {@link Board} represented by the Cartesian coordinate plane.
 * 
 * The small {@link Coin} is represented by its {@link Position} in the plane which is occupiable, while its intrinsic value equals {@link Pacmans#SMALL_COIN_VALUE} and its label equals {@code 'o'}.
 * 
 * @author Lovro Šubelj
 */
public class SmallCoin extends Coin {

	/**
	 * Constructs a small {@link Coin} on a {@link Board} represented by the Cartesian coordinate plane.
	 * 
	 * The small {@link Coin} is specified by its {@link Position} in the plane which is occupiable, while its intrinsic value equals {@link Pacmans#SMALL_COIN_VALUE} and its label equals {@code 'o'}.
	 * 
	 * @param position {@link Position} of the {@link Coin} on a {@link Board}
	 */
	public SmallCoin(Position position) {
		super(position, Pacmans.SMALL_COIN_VALUE, 'o');
	}
	
}