package si.lj.uni.fmf.pro2.lectures.pacmans;

/**
 * Class representing a tiny {@link Coin} on a {@link Board} represented by the Cartesian coordinate plane.
 * 
 * The tiny {@link Coin} is represented by its {@link Position} in the plane which is occupiable, while its intrinsic value equals {@link Pacmans#TINY_COIN_VALUE} and its label equals {@code '°'}.
 * 
 * @author Lovro Šubelj
 */
public class TinyCoin extends Coin {

	/**
	 * Constructs a tiny {@link Coin} on a {@link Board} represented by the Cartesian coordinate plane.
	 * 
	 * The tiny {@link Coin} is specified by its {@link Position} in the plane which is occupiable, while its intrinsic value equals {@link Pacmans#TINY_COIN_VALUE} and its label equals {@code '°'}.
	 * 
	 * @param position {@link Position} of the {@link Coin} on a {@link Board}
	 */
	public TinyCoin(Position position) {
		super(position, Pacmans.TINY_COIN_VALUE, '°');
	}
	
}