package si.lj.uni.fmf.pro2.lectures.quoridor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AIPlayer extends Player {

	public AIPlayer(boolean top) {
		super(top);
	}

	public AIPlayer(int x, int y, boolean top) {
		super(x, y, top);
	}
	
	public AIPlayer(Player player) {
		super(player);
	}
	
	public boolean move(Quoridor quoridor) {
		List<Move> moves = new ArrayList<Move>();
		if (getX() > 0 && (quoridor.getOther().getX() != getX() - 1 || quoridor.getOther().getY() != getY()) && !quoridor.getWalls().contains(new Wall(getX(), getY(), false)))
			moves.add(new Move(getX() - 1, getY()));
		if (getX() < 8 && (quoridor.getOther().getX() != getX() + 1 || quoridor.getOther().getY() != getY()) && !quoridor.getWalls().contains(new Wall(getX() + 1, getY(), false)))
			moves.add(new Move(getX() + 1, getY()));
		if (getY() > 0 && (quoridor.getOther().getX() != getX() || quoridor.getOther().getY() != getY() - 1) && !quoridor.getWalls().contains(new Wall(getX(), getY(), true)))
			moves.add(new Move(getX(), getY() - 1));
		if (getY() < 8 && (quoridor.getOther().getX() != getX() || quoridor.getOther().getY() != getY() + 1) && !quoridor.getWalls().contains(new Wall(getX(), getY() + 1, true)))
			moves.add(new Move(getX(), getY() + 1));
		
		if (moves.isEmpty())
			return false;
		
		Graph graph = quoridor.getGraph();

		Move move = moves.get(0);
		switch (quoridor.getStrategy()) {
		case GREEDY:
			for (int i = 1; i < moves.size(); i++)
				if (graph.minimumDistance(this, moves.get(i)) < graph.minimumDistance(this, move))
					move = moves.get(i);
			break;
		case AVERAGE:
			for (int i = 1; i < moves.size(); i++)
				if (graph.averageDistance(this, moves.get(i)) < graph.averageDistance(this, move))
					move = moves.get(i);
			break;
		case RANDOM: default:
			move = moves.get((int)(Math.random() * moves.size()));
			break;
		}
		
		setX(move.getX());
		setY(move.getY());
		
		return true;
	}
	
	public boolean wall(Quoridor quoridor) {
		List<Wall> walls = new ArrayList<Wall>();
		for (int i = 1; i < 9; i++)
			for (int j = 0; j < 9; j++)
				walls.add(new Wall(i, j, isTop(), false));
		for (int i = 0; i < 9; i++)
			for (int j = 1; j < 9; j++)
				walls.add(new Wall(i, j, isTop(), true));
		
		for (Iterator<Wall> iterator = walls.iterator(); iterator.hasNext(); ) {
			Wall wall = iterator.next();
			if (quoridor.getWalls().contains(wall) || !quoridor.getGraph(wall).isConnected())
				iterator.remove();
		}
		
		if (walls.isEmpty())
			return false;

		Wall wall = walls.get(0);
		switch (quoridor.getStrategy()) {
		case GREEDY:
			for (int i = 1; i < walls.size(); i++)
				if (quoridor.getGraph(walls.get(i)).minimumDistance(quoridor.getOther()) > quoridor.getGraph(wall).minimumDistance(quoridor.getOther()))
					wall = walls.get(i);
			break;
		case AVERAGE:
			for (int i = 1; i < walls.size(); i++)
				if (quoridor.getGraph(walls.get(i)).averageDistance(quoridor.getOther()) > quoridor.getGraph(wall).averageDistance(quoridor.getOther()))
					wall = walls.get(i);
			break;
		case RANDOM: default:
			wall = walls.get((int)(Math.random() * walls.size()));
			break;
		}
		
		quoridor.getWalls().add(wall);
		decrementWalls();
		
		return true;
	}
	
}