package si.lj.uni.fmf.pro2.lectures.quoridor;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class GUI extends JFrame {
	
	private static final long serialVersionUID = 1L;
	
	private Quoridor quoridor;

	public GUI(Quoridor quoridor) {
		super();
		
		this.quoridor = quoridor;
		
		setTitle("Quoridor");
		setLayout(new BorderLayout());
		setMinimumSize(new Dimension(800, 800));
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		add(new Panel(quoridor), BorderLayout.CENTER);
		
		JMenuBar bar = new JMenuBar(); 
		setJMenuBar(bar);
		
		JMenu menu = new JMenu("File");
	    bar.add(menu);
	    
	    JMenuItem item = new JMenuItem("New");
	    item.setAccelerator(KeyStroke.getKeyStroke('N', Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.setIcon(UIManager.getIcon("FileView.fileIcon"));
	    item.setEnabled(false);
	    menu.add(item);
	    
	    item = new JMenuItem("Open...");
	    item.setAccelerator(KeyStroke.getKeyStroke('O', Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.setIcon(UIManager.getIcon("Tree.openIcon"));
	    item.setEnabled(false);
	    menu.add(item);
	    
	    menu.addSeparator();
	    
	    item = new JMenuItem("Save");
	    item.setIcon(UIManager.getIcon("FileView.hardDriveIcon"));
	    item.setEnabled(false);
	    menu.add(item);
	    
	    item = new JMenuItem("Save As...");
	    item.setEnabled(false);
	    menu.add(item);
	    
	    menu.addSeparator();
	    
	    item = new JMenuItem("Export...");
	    item.setEnabled(false);
	    menu.add(item);
		
		menu = new JMenu("Game");
	    bar.add(menu);
	    
	    item = new JMenuItem("New Player");
	    item.setEnabled(false);
	    menu.add(item);
	    
	    item = new JMenuItem("Next Player");
	    item.setAccelerator(KeyStroke.getKeyStroke('P', Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				quoridor.nextPlayer();
				quoridor.draw();
			}
			
		});
	    menu.add(item);
	    
	    menu.addSeparator();
	    
	    item = new JMenuItem("Reset Game");
	    item.setAccelerator(KeyStroke.getKeyStroke('R', Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.addActionListener(new ActionListener() {

	    	@Override
	    	public void actionPerformed(ActionEvent e) {
	    		quoridor.reset();
	    		quoridor.draw();
	    	}

	    });
	    menu.add(item);

	    item = new JMenuItem("Reset Walls");
	    item.setAccelerator(KeyStroke.getKeyStroke('W', Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
	    item.addActionListener(new ActionListener() {

	    	@Override
	    	public void actionPerformed(ActionEvent e) {
	    		quoridor.rewall();
	    		quoridor.draw();
	    	}

	    });
	    menu.add(item);

	    menu.addSeparator();

	    for (Player player: quoridor.getPlayers()) {
	    	item = new JMenuItem("Reset " + player.getName());
	    	item.setAccelerator(KeyStroke.getKeyStroke(player.getName().charAt(0), ActionEvent.ALT_MASK + ActionEvent.SHIFT_MASK));
	    	item.addActionListener(new ActionListener() {

	    		@Override
	    		public void actionPerformed(ActionEvent e) {
	    			if (!quoridor.isFinished())
	    				quoridor.reset(player.isTop());
	    			quoridor.draw();
	    		}

	    	});
	    	menu.add(item);
	    }

	    menu = new JMenu("AI");
	    bar.add(menu);
	    
	    ButtonGroup group = new ButtonGroup();
	    
	    JRadioButtonMenuItem radio = new JRadioButtonMenuItem("Greedy AI", quoridor.getStrategy() == Strategy.GREEDY);
	    radio.setAccelerator(KeyStroke.getKeyStroke('G', ActionEvent.ALT_MASK));
	    radio.addActionListener(new ActionListener() {

    		@Override
    		public void actionPerformed(ActionEvent e) {
    			quoridor.setStrategy(Strategy.GREEDY);
    			quoridor.draw();
    		}

    	});
	    group.add(radio);
    	menu.add(radio);
    	
    	radio = new JRadioButtonMenuItem("Average AI", quoridor.getStrategy() == Strategy.AVERAGE);
    	radio.setAccelerator(KeyStroke.getKeyStroke('A', ActionEvent.ALT_MASK));
    	radio.addActionListener(new ActionListener() {

    		@Override
    		public void actionPerformed(ActionEvent e) {
    			quoridor.setStrategy(Strategy.AVERAGE);
    			quoridor.draw();
    		}

    	});
    	group.add(radio);
    	menu.add(radio);
    	
    	radio = new JRadioButtonMenuItem("Random AI", quoridor.getStrategy() == Strategy.RANDOM);
    	radio.setAccelerator(KeyStroke.getKeyStroke('R', ActionEvent.ALT_MASK));
    	radio.addActionListener(new ActionListener() {

    		@Override
    		public void actionPerformed(ActionEvent e) {
    			quoridor.setStrategy(Strategy.RANDOM);
    			quoridor.draw();
    		}

    	});
    	group.add(radio);
    	menu.add(radio);
	    
    	menu.addSeparator();
    	
	    for (Player player: quoridor.getPlayers()) {
	    	item = new JMenuItem("Toggle " + player.getName());
	    	item.setAccelerator(KeyStroke.getKeyStroke(player.getName().charAt(0), ActionEvent.SHIFT_MASK));
	    	item.addActionListener(new ActionListener() {

	    		@Override
	    		public void actionPerformed(ActionEvent e) {
	    			quoridor.toggle(player.isTop());
	    			quoridor.draw();
	    		}

	    	});
	    	menu.add(item);
	    }
	    
	    bar.add(new JMenu("Help"));
	    
		pack(); 
	}

	public Quoridor getQuoridor() {
		return quoridor;
	}
	
}