package si.lj.uni.fmf.pro2.lectures.quoridor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Graph {

	private List<Set<Integer>> neighbors;
	
	public Graph(Set<Wall> walls) {
		super();
		
		neighbors = new ArrayList<Set<Integer>>();
		for (int i = 0; i < 81; i++)
			neighbors.add(new HashSet<Integer>());
		
		for (int i = 0; i < 9; i++)
			for (int j = 0; j < 8; j++)
				if (!walls.contains(new Wall(j + 1, i, false)))
					addEdge(9 * i + j, 9 * i + j + 1);
	
		for (int j = 0; j < 9; j++)
			for (int i = 0; i < 8; i++)
				if (!walls.contains(new Wall(j, i + 1, true)))
					addEdge(9 * i + j, 9 * (i + 1) + j);
	}
	
	public void addEdge(int i, int j) {
		neighbors.get(i).add(j);
		neighbors.get(j).add(i);
	}
	
	public void removeEdge(int i, int j) {
		neighbors.get(i).remove(j);
		neighbors.get(j).remove(i);
	}
	
	public void removeEdge(Wall wall) {
		if (wall.isHorizontal())
			removeEdge(9 * (wall.getY() - 1) + wall.getX(), 9 * wall.getY() + wall.getX());
		else
			removeEdge(9 * wall.getY() + wall.getX() - 1, 9 * wall.getY() + wall.getX());
	}

	public boolean isConnected() {
		Set<Integer> nodes = new HashSet<Integer>();
		for (int i = 1; i < 81; i++)
			nodes.add(i);
		
		List<Integer> stack = new LinkedList<Integer>();
		stack.add(0);
		
		int LCC = 0;
		while (!stack.isEmpty()) {
			int i = stack.remove(0);
			
			for (int j: neighbors.get(i))
				if (nodes.remove(j))
					stack.add(0, j);
			
			LCC++;
		}
		
		return LCC == 81;
	}
	
	public int minimumDistance(Player player) {
		return minimumDistance(player, computeDistances(player.getX(), player.getY()));
	}
	
	public int minimumDistance(Player player, Move move) {
		return minimumDistance(player, computeDistances(move.getX(), move.getY()));
	}
	
	public int minimumDistance(Player player, int[] distances) {
		int distance = Integer.MAX_VALUE;
		for (int i = player.isTop()? 72: 0; i < (player.isTop()? 81: 9); i++)
			if (distances[i] < distance)
				distance = distances[i];
		
		return distance;
	}
	
	public double averageDistance(Player player) {
		return averageDistance(player, computeDistances(player.getX(), player.getY()));
	}
	
	public double averageDistance(Player player, Move move) {
		return averageDistance(player, computeDistances(move.getX(), move.getY()));
	}
	
	public double averageDistance(Player player, int[] distances) {
		int distance = 0;
		for (int i = player.isTop()? 72: 0; i < (player.isTop()? 81: 9); i++)
			distance += distances[i];
		
		return distance / 9.0;
	}
	
	private int[] computeDistances(int x, int y) {
		return computeDistances(9 * y + x);
	}
	
	private int[] computeDistances(int i) {
		int[] distances = new int[81];
		for (int j = 0; j < 81; j++)
			distances[j] = -1;
		List<Integer> queue = new LinkedList<Integer>();
		
		distances[i] = 0;
		queue.add(i);
		
		while (!queue.isEmpty()) {
			i = queue.remove(0);
			
			for (int j: neighbors.get(i))
				if (distances[j] == -1) {
					distances[j] = distances[i] + 1;
					queue.add(j);
				}
		}
		
		return distances;
	}

}