package si.lj.uni.fmf.pro2.lectures.quoridor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class Panel extends JPanel {

	private static final long serialVersionUID = 1L;

	protected static final int BORDER_SIZE = 50;

	protected static final float GRID_WIDTH = 5.0f;

	protected static final Color GRID_COLOR = new Color(192, 192, 192);

	protected static final Color TOP_COLOR = new Color(177, 69, 71);

	protected static final Color BOTTOM_COLOR = new Color(81, 132, 186);
	
	protected static Image topIcon = null;
	
	protected static Image bottomIcon = null;
	
	static {
		try {
			topIcon = ImageIO.read(new File("icons", "red.png"));
			bottomIcon = ImageIO.read(new File("icons", "blue.png"));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private Quoridor quoridor;

	public Panel(Quoridor quoridor) {
		super();
		
		this.quoridor = quoridor;

		setFocusable(true);
		setBackground(Color.WHITE);

		addMouseListener(new MouseListener() {

			@Override
			public void mouseReleased(MouseEvent e) {

			}

			@Override
			public void mousePressed(MouseEvent e) {

			}

			@Override
			public void mouseExited(MouseEvent e) {

			}

			@Override
			public void mouseEntered(MouseEvent e) {

			}

			@Override
			public void mouseClicked(MouseEvent e) {
				if (!quoridor.isFinished() && !(quoridor.getPlayer() instanceof AIPlayer)) {
					double width = (getWidth() - 2 * Panel.BORDER_SIZE) / 9.0;
					double height = (getHeight() - 2 * Panel.BORDER_SIZE) / 9.0;

					double x = (e.getX() - Panel.BORDER_SIZE) / width;
					double y = (e.getY() - Panel.BORDER_SIZE) / height;

					int X = (int)Math.round(x);
					int Y = (int)Math.round(y);

					if (x > 0.0 && x < 9.0 && y > 0.0 && y < 9.0)
						if (Math.abs(x - X) * width <= Panel.GRID_WIDTH / 2.0 || Math.abs(y - Y) * height <= Panel.GRID_WIDTH / 2.0) {
							if (quoridor.getPlayer().getWalls() > 0) {
								Wall wall = null;
								if (Math.abs(x - X) * width <= Panel.GRID_WIDTH / 2.0 && X > 0 && X < 9)
									wall = new Wall(X, (int)Math.floor(y), quoridor.isTop(), false);
								else if (Math.abs(y - Y) * height <= Panel.GRID_WIDTH / 2.0 && Y > 0 && y < 9)
									wall = new Wall((int)Math.floor(x), Y, quoridor.isTop(), true);

								if (wall != null && !quoridor.getWalls().contains(wall) && quoridor.getGraph(wall).isConnected()) {
									quoridor.getWalls().add(wall);
									quoridor.getPlayer().decrementWalls();
									quoridor.nextPlayer();
								}
							}
						}
						else {
							X = (int)Math.floor(x);
							Y = (int)Math.floor(y);

							if (Math.abs(quoridor.getPlayer().getX() - X) + Math.abs(quoridor.getPlayer().getY() - Y) == 1 && (quoridor.getOther().getX() != X || quoridor.getOther().getY() != Y)) {
								boolean illegal = false;
								for (Wall wall: quoridor.getWalls())
									if (wall.isHorizontal() && quoridor.getPlayer().getX() == X && X == wall.getX() && (quoridor.getPlayer().getY() > Y? quoridor.getPlayer().getY() == wall.getY(): Y == wall.getY()) || !wall.isHorizontal() && quoridor.getPlayer().getY() == Y && Y == wall.getY() && (quoridor.getPlayer().getX() > X? quoridor.getPlayer().getX() == wall.getX(): X == wall.getX())) {
										illegal = true;
										break;
									}

								if (!illegal) {
									quoridor.getPlayer().setX(X);
									quoridor.getPlayer().setY(Y);
									quoridor.nextPlayer();
								}
							}
						}

					for (Player player: quoridor.getPlayers())
						if (player.hasWon())
							quoridor.setFinished();
				}
				else if (quoridor.isFinished())
					quoridor.reset();

				quoridor.draw();
			}
		});
	}

	@Override
	public void paint(Graphics g) {
		super.paint(g);
		
		Graphics2D graphics = (Graphics2D)g;
		
		double width = (getWidth() - 2 * Panel.BORDER_SIZE) / 9.0;
		double height = (getHeight() - 2 * Panel.BORDER_SIZE) / 9.0;
		
		graphics.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER));
		graphics.setColor(new Color(Panel.BOTTOM_COLOR.getRed(), Panel.BOTTOM_COLOR.getGreen(), Panel.BOTTOM_COLOR.getBlue(), 64));
		
		graphics.fillRect(Panel.BORDER_SIZE, Panel.BORDER_SIZE, getWidth() - 2 * Panel.BORDER_SIZE, (int)Math.round(height));
		
		graphics.setColor(new Color(Panel.TOP_COLOR.getRed(), Panel.TOP_COLOR.getGreen(), Panel.TOP_COLOR.getBlue(), 64));
		
		graphics.fillRect(Panel.BORDER_SIZE, (int)Math.round(Panel.BORDER_SIZE + 8 * height), getWidth() - 2 * Panel.BORDER_SIZE, (int)Math.round(height));
		
		graphics.setStroke(new BasicStroke(Panel.GRID_WIDTH, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER));
		graphics.setColor(Panel.GRID_COLOR);
		
		for (int i = 1; i < 9; i++) {
			graphics.drawLine(Panel.BORDER_SIZE, (int)Math.round(Panel.BORDER_SIZE + i * height), getWidth() - Panel.BORDER_SIZE, (int)Math.round(Panel.BORDER_SIZE + i * height));
			graphics.drawLine((int)Math.round(Panel.BORDER_SIZE + i * width), Panel.BORDER_SIZE, (int)Math.round(Panel.BORDER_SIZE + i * width), getHeight() - Panel.BORDER_SIZE);
		}
		
		graphics.setStroke(new BasicStroke(2 * Panel.GRID_WIDTH, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER));
		
		for (Wall wall: quoridor.getWalls()) {
			if (wall.isTop())
				graphics.setColor(Panel.TOP_COLOR);
			else
				graphics.setColor(Panel.BOTTOM_COLOR);
			
			if (wall.isHorizontal())
				graphics.drawLine((int)Math.round(Panel.BORDER_SIZE + wall.getX() * width), (int)Math.round(Panel.BORDER_SIZE + wall.getY() * height), (int)Math.round(Panel.BORDER_SIZE + (wall.getX() + 1) * width), (int)Math.round(Panel.BORDER_SIZE + wall.getY() * height));
			else
				graphics.drawLine((int)Math.round(Panel.BORDER_SIZE + wall.getX() * width), (int)Math.round(Panel.BORDER_SIZE + wall.getY() * height), (int)Math.round(Panel.BORDER_SIZE + wall.getX() * width), (int)Math.round(Panel.BORDER_SIZE + (wall.getY() + 1) * height));
		}
		
		graphics.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_MITER));
		
		for (Player player: quoridor.getPlayers()) {
			graphics.drawImage(player.isTop()? topIcon: bottomIcon, (int)Math.round(Panel.BORDER_SIZE + player.getX() * width + Panel.GRID_WIDTH / 2), (int)Math.round(Panel.BORDER_SIZE + player.getY() * height), (int)width, (int)height, null);
			
			graphics.setColor(Color.BLACK);
			graphics.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 14));

			FontMetrics metrics = graphics.getFontMetrics();
			if (player instanceof AIPlayer)
				graphics.drawString("AI", (int)Math.round(Panel.BORDER_SIZE + (player.getX() + 0.5) * width - metrics.stringWidth("AI") / 2), (int)Math.round(Panel.BORDER_SIZE + (player.getY() + 0.8) * height));
		}

		if (quoridor.isFinished()) {
			graphics.setColor(new Color(255, 255, 255, 192));
			graphics.fillRect(0, 0, getWidth(), getHeight());
			
			graphics.setStroke(new BasicStroke(1.0f));
			graphics.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 24));
			FontMetrics metrics = graphics.getFontMetrics();
			
			String message = quoridor.getPlayers()[quoridor.getPlayers()[0].hasWon()? 0: 1].getName() + " wins!";
			
			RoundRectangle2D rectangle = new RoundRectangle2D.Float((getWidth() - Panel.BORDER_SIZE - metrics.stringWidth(message)) / 2, getHeight() / 2 - Panel.BORDER_SIZE / 2, metrics.stringWidth(message) + Panel.BORDER_SIZE, Panel.BORDER_SIZE, 10, 10);
			
			graphics.setColor(Color.WHITE);
			
	        graphics.fill(rectangle);
			
	        graphics.setColor(Color.BLACK);
	        
	        graphics.draw(rectangle);
			
			graphics.drawString(message, (getWidth() - metrics.stringWidth(message)) / 2, getHeight() / 2 + metrics.getAscent() / 2);
		}
	}

	public Quoridor getQuoridor() {
		return quoridor;
	}

}