package si.lj.uni.fmf.pro2.lectures.quoridor;

public class Player {
	
	private int x;
	
	private int y;
	
	private String name;
	
	private boolean top;
	
	private int walls;
	
	public Player(boolean top) {
		this(4, top? 0: 8, top);
	}
	
	public Player(int x, int y, boolean top) {
		super();
		
		this.x = x;
		this.y = y;
		this.top = top;

		name = top? "Red": "Blue";
		walls = 10;
	}
	
	public Player(Player player) {
		super();
		
		x = player.getX();
		y = player.getY();
		top = player.isTop();
		
		
		name = player.getName();
		walls = player.getWalls();
	}

	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}
	
	public int getWalls() {
		return walls;
	}
	
	public void resetWalls() {
		walls = 10;
	}

	public void decrementWalls() {
		if (walls > 0)
			walls--;
	}
	
	public String getName() {
		return name;
	}

	public boolean isTop() {
		return top;
	}

	public boolean hasWon() {
		return top && y == 8 || !top && y == 0;
	}
	
}