package si.lj.uni.fmf.pro2.lectures.quoridor;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class Quoridor {
	
	protected static final long GAME_SLEEP = 100L;
	
	protected static final long MOVE_SLEEP = 500L;
	
	protected static final double MOVE_PROBABILITY = 0.8;
	
	private Strategy strategy = Strategy.GREEDY;

	private boolean top;
	
	private boolean finished;
	
	private Player[] players; 
	
	private Set<Wall> walls;
	
	private GUI GUI;
	
	public Quoridor() {
		super();

		reset();
		
		GUI = new GUI(this);
		GUI.setVisible(true);
	}
	
	public Strategy getStrategy() {
		return strategy;
	}

	public void setStrategy(Strategy strategy) {
		this.strategy = strategy;
	}
	
	public boolean isTop() {
		return top;
	}
	
	public boolean isFinished() {
		return finished;
	}
	
	public void setFinished() {
		finished = true;
	}

	public Player[] getPlayers() {
		return players;
	}
	
	public Player getPlayer() {
		return players[top? 0: 1];
	}
	
	public Player getOther() {
		return players[top? 1: 0];
	}

	public void nextPlayer() {
		top = !top;
	}
	
	public Set<Wall> getWalls() {
		return walls;
	}
	
	public Graph getGraph() {
		return new Graph(walls);
	}
	
	public Graph getGraph(Wall wall) {
		Graph graph = new Graph(walls);
		graph.removeEdge(wall);
		return graph;
	}
	
	public GUI getGUI() {
		return GUI;
	}

	protected void draw() {
		if (GUI != null)
			GUI.repaint();
	}

	public void play() {
		while (true) {
			if (getPlayer() instanceof AIPlayer && !isFinished()) {
				AIPlayer player = (AIPlayer)getPlayer();
				
				try {
					Thread.sleep(MOVE_SLEEP);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				
				if (player.getWalls() == 0 || Math.random() < MOVE_PROBABILITY || !player.wall(this)) // lazy evaluation
					if (!player.move(this) && player.getWalls() > 0)
						player.wall(this);
				
				if (player.hasWon())
					setFinished();
				else
					nextPlayer();
			}
			
			draw();
			
			try {
				Thread.sleep(GAME_SLEEP);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
	
	public void reset() {
		top = true;
		finished = false;
		
		players = new Player[] { new Player(true), new AIPlayer(false) };
		walls = new TreeSet<Wall>();
	}
	
	public void rewall() {
		walls = new TreeSet<Wall>();
		
		for (Player player: players)
			player.resetWalls();
	}

	public void reset(boolean top) {
		players[top? 0: 1] = players[top? 0: 1] instanceof AIPlayer? new AIPlayer(top): new Player(top);
		
		for (Iterator<Wall> iterator = walls.iterator(); iterator.hasNext(); )
			if (iterator.next().isTop() == top)
				iterator.remove();
	}
	
	public void toggle(boolean top) {
		if (top)
			players[0] = players[0] instanceof AIPlayer? new Player(players[0]): new AIPlayer(players[0]);
		else
			players[1] = players[1] instanceof AIPlayer? new Player(players[1]): new AIPlayer(players[1]);
	}
	
	public static void main(String[] args) {
		System.setProperty("apple.laf.useScreenMenuBar", "true");
		
		new Quoridor().play();
	}
	
}

