package si.lj.uni.fmf.pro2.lectures.quoridor;

public class Wall implements Comparable<Wall> {
	
	private int x;
	
	private int y;
	
	private boolean top;
	
	private boolean horizontal;
	
	public Wall(int x, int y, boolean horizontal) {
		this(x, y, false, horizontal);
	}

	public Wall(int x, int y, boolean top, boolean horizontal) {
		super();
		
		this.x = x;
		this.y = y;
		this.top = top;
		this.horizontal = horizontal;
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	public boolean isTop() {
		return top;
	}

	public boolean isHorizontal() {
		return horizontal;
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof Wall))
			return false;
		
		Wall wall = (Wall)obj;
		return wall.getX() == x && wall.getY() == y && wall.isHorizontal() == horizontal;
	}

	@Override
	public int compareTo(Wall wall) {
		return (wall.getX() + "-" + wall.getY() + "-" + wall.isHorizontal()).compareTo(x + "-" + y + "-" + horizontal);
	}
	
}