package si.lj.uni.fmf.pro2.lectures.pacmans;

/**
 * Class representing a block {@link Cell} on a {@link Board} represented by the Cartesian coordinate plane.
 * 
 * The block {@link Cell} is represented by its {@link Position} in the plane which is non-occupiable, while its intrinsic value equals {@code 0} and its label equals {@code '#'}.
 * 
 * @author Lovro Šubelj
 */
public class Block extends Cell {

	/**
	 * Constructs a block {@link Cell} on a {@link Board} represented by the Cartesian coordinate plane.
	 * 
	 * The block {@link Cell} is specified by its {@link Position} in the plane which is non-occupiable, while its intrinsic value equals {@code 0} and its label equals {@code '#'}.
	 * 
	 * @param position {@link Position} of the {@link Cell} on a {@link Board}
	 */
	public Block(Position position) {
		super(position, 0, '#', false);
	}
	
}