package si.lj.uni.fmf.pro2.lectures.pacmans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Pacmans {
	
	protected static final int BIG_COIN_VALUE = 9;
	
	protected static final int SMALL_COIN_VALUE = 3;
	
	protected static final int TINY_COIN_VALUE = 1;
	
	protected static final int NO_MOVE_VALUE = -9;
	
	protected static final long MOVE_SLEEP_TIME = 150;
	
	protected static final long PLAY_SLEEP_TIME = 2500;
	
	protected static final double COINS_PROBABILITY = 0.5;
	
	protected static final double BLOCKS_PROBABILITY = 0.1667;
	
	protected static final double GREEDY_PROBABILITY = 0.2;

	private int runs;
	
	private int plays;
	
	private Board board;
	
	private List<Pacman> pacmans;
	
	private Map<Pacman, Double> scores;
	
	public Pacmans(int size, int number) {
		this(size, size, number);
	}
	
	public Pacmans(int width, int height, int number) {
		runs = 0;
		plays = 0;
		
		board = new Board(width, height, number);
		
		pacmans = new ArrayList<Pacman>();
		scores = new HashMap<Pacman, Double>();
		
		for (int i = 0; i < width; i++) 
			for (int j = 0; j < height; j++) 
				if (board.getCell(new Position(i, j)) instanceof Pacman) {
					Pacman pacman = (Pacman)board.getCell(new Position(i, j));
					pacmans.add(pacman);
					scores.put(pacman, 0.0);
				}
		
		Collections.sort(pacmans, new Comparator<Pacman>() {
			@Override
			public int compare(Pacman first, Pacman second) {
				if (scores.get(first).equals(scores.get(second)))
					return new Character(first.getLabel()).compareTo(second.getLabel());
				
				return -scores.get(first).compareTo(scores.get(second));
			}
		});
	}

	public int getRuns() {
		return runs;
	}
	
	public void setRuns(int runs) {
		this.runs = runs;
	}

	public int getPlays() {
		return plays;
	}

	public void setPlays(int plays) {
		this.plays = plays;
	}

	public Board getBoard() {
		return board;
	}

	public List<Pacman> getPacmans() {
		return pacmans;
	}
	
	public Map<Pacman, Double> getScores() {
		return scores;
	}

	protected void move(Pacman pacman) {
		List<Position> positions = new ArrayList<Position>();
		positions.add(pacman.getPosition());
		
		double best = Pacmans.NO_MOVE_VALUE;
		for (Position position: new Position[] { pacman.getPosition().move(0, -1), pacman.getPosition().move(0, 1), pacman.getPosition().move(-1, -1), pacman.getPosition().move(-1, 0), pacman.getPosition().move(-1, 1), pacman.getPosition().move(1, -1), pacman.getPosition().move(1, 0), pacman.getPosition().move(1, 1) }) {
			double value = board.getValue(position, !pacman.isPrime());
			if (value >= best) {
				if (value > best)
					positions.clear();
				positions.add(position);

				best = value;
			}
		}
		
		Position position = positions.get((int)(Math.random() * positions.size()));
		scores.put(pacman, scores.get(pacman) + board.getValue(position));
		
		board.setCell(pacman.getPosition(), new Empty(pacman.getPosition()));
		board.setCell(position, pacman);
		
		pacman.setPosition(position);
	}
	
	protected void move() {
		Collections.shuffle(pacmans);
		
		for (Pacman pacman: pacmans)
			move(pacman);
		
		Collections.sort(pacmans, new Comparator<Pacman>() {
			@Override
			public int compare(Pacman first, Pacman second) {
				if (scores.get(first).equals(scores.get(second)))
					return new Character(first.getLabel()).compareTo(second.getLabel());
				
				return -scores.get(first).compareTo(scores.get(second));
			}
		});
	}
	
	protected void update() {
		for (int i = 0; i < board.getWidth(); i++) 
			for (int j = 0; j < board.getHeight(); j++) 
				if (board.getCell(new Position(i, j)) instanceof Block)
					board.setCell(new Position(i, j), Cell.random(new Position(i, j)));
	}

	public void reset() {
		runs = 0;
		plays = 0;
		
		board = new Board(board.getWidth(), board.getHeight(), pacmans.size());
		
		pacmans = new ArrayList<Pacman>();
		scores = new HashMap<Pacman, Double>();
		
		for (int i = 0; i < board.getWidth(); i++) 
			for (int j = 0; j < board.getHeight(); j++) 
				if (board.getCell(new Position(i, j)) instanceof Pacman) {
					Pacman pacman = (Pacman)board.getCell(new Position(i, j));
					pacmans.add(pacman);
					scores.put(pacman, 0.0);
				}
		
		Collections.sort(pacmans, new Comparator<Pacman>() {
			@Override
			public int compare(Pacman first, Pacman second) {
				if (scores.get(first).equals(scores.get(second)))
					return new Character(first.getLabel()).compareTo(second.getLabel());
				
				return -scores.get(first).compareTo(scores.get(second));
			}
		});
	}
	
	protected void draw() {
		System.out.println(this);
	}
	
	public void play() throws InterruptedException {
		draw();

		while (!board.isEmpty()) {
			plays++;
			
			Thread.sleep(PLAY_SLEEP_TIME);
			
			while (board.hasValue()) {
				runs++;
				
				move();
				draw();

				Thread.sleep(MOVE_SLEEP_TIME);
			}

			Thread.sleep(PLAY_SLEEP_TIME);

			update();
			draw();
		}
	}
	
	@Override
	public String toString() {
		String scoring = "";
		for (Pacman pacman: pacmans)
			scoring += pacman + ":" + scores.get(pacman).intValue() + "  ";
		while (scoring.length() < 2 * board.getWidth() + 1)
			scoring = " " + scoring + " ";
		
		String coins = "Ʃ:" + board.getValue() + "  ";
		for (Coin coin: new Coin[] { new BigCoin(null), new SmallCoin(null), new TinyCoin(null) }) {
			int count = board.getCount(coin.getClass());
			if (count > 0)
				coins += coin + ":" + count + "x" + coin.getValue() + "  ";
		}
		Block block = new Block(null);
		int count = board.getCount(block.getClass());
		if (board.getCount(block.getClass()) > 0)
			coins += block + ":" + count + "x" + block.getValue() + "  ";
		while (coins.length() < 2 * board.getWidth() + 1)
			coins = " " + coins + " ";
		
		return "\n" + board.toString() + "\n   " + scoring + "\n   " + coins;
	}
	
	public static void main(String[] args) {
		int size = args.length > 0? Integer.parseInt(args[0]): 24;
		int number = args.length > 1? Integer.parseInt(args[1]): 6;
		
		Pacmans pacmans = new Pacmans(size, number);
		
		try {
			pacmans.play();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
}
