package si.lj.uni.fmf.pro2.lectures.vacmans;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import si.lj.uni.fmf.pro2.lectures.pacmans.Pacman;

public class Console extends JPanel {
	
	private static final long serialVersionUID = 1L;
	
	public Console(Vacmans vacmans) {
		super();
		
		setFocusable(false);
		setPreferredSize(new Dimension(getWidth(), GUI.CONSOLE_HEIGHT));
		
		add(new JLabel("    "));
		
		JButton reset = new JButton("Reset");
		reset.setToolTipText("Reset PAC-MANs");
		reset.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				vacmans.setRunning(false);
				vacmans.getRunButton().setSelected(false);
				vacmans.getRunButton().setIcon(new ImageIcon("icons/sacman.png"));
				vacmans.getRunButton().setToolTipText("Start PAC-MANs");
				vacmans.reset();
				
				vacmans.getGUI().repaint();
			}
		});
		reset.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, 13));
		reset.setFocusable(false);
		add(reset);
		
		JButton prime = new JButton("Prime");
		prime.setToolTipText("Reprime PAC-MANs");
		prime.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				for (Pacman pacman: vacmans.getPacmans())
					pacman.setPrime(Math.random() < 0.5);
				
				vacmans.getGUI().repaint();
			}
		});
		prime.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, 13));
		prime.setFocusable(false);
		add(prime);
		
		add(new JLabel("  "));
		
		vacmans.getRunButton().setToolTipText("Start PAC-MANs");
		vacmans.getRunButton().setIcon(new ImageIcon("icons/sacman.png"));
		vacmans.getRunButton().addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				vacmans.setRunning(vacmans.getRunButton().isSelected());
				vacmans.getRunButton().setIcon(vacmans.getRunButton().isSelected()? new ImageIcon("icons/pacman.png"):  new ImageIcon("icons/sacman.png"));
				vacmans.getRunButton().setToolTipText(vacmans.getRunButton().isSelected()? "Stop PAC-MANs":  "Start PAC-MANs");
				
				vacmans.getGUI().repaint();
			}
		});
		vacmans.getRunButton().setPreferredSize(new Dimension(GUI.CONTROL_SIZE, GUI.CONTROL_SIZE));
		vacmans.getRunButton().setFocusable(false);
		add(vacmans.getRunButton());
		
		add(new JLabel(" "));
		
		vacmans.getSpeedSlider().setToolTipText("PAC-MANs speed");
		vacmans.getSpeedSlider().addChangeListener(new ChangeListener() {
			@Override
			public void stateChanged(ChangeEvent e) {
				vacmans.setSleep(500 - vacmans.getSpeedSlider().getValue());
				
				vacmans.getGUI().repaint();
			}
		});
		vacmans.getSpeedSlider().setFocusable(false);
		add(vacmans.getSpeedSlider());
	}

}