package si.lj.uni.fmf.pro2.lectures.vacmans;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JFrame;

public class GUI extends JFrame {
	
	protected static final int CELL_SIZE = 24;
	
	protected static final int BORDER_SIZE = 16;
	
	protected static final int INDENT_SIZE = 4;
	
	protected static final int CONTROL_SIZE = 40;
	
	protected static final int CONSOLE_HEIGHT = 48;
	
	protected static final int SUMMARY_HEIGHT = 112;
	
	private static final long serialVersionUID = 1L;

	public GUI(Vacmans vacmans) {
		super();
		
		setTitle("PAC-MANs");
		getRootPane().putClientProperty("apple.awt.brushMetalLook", true);
		setPreferredSize(new Dimension(vacmans.getBoard().getWidth() * CELL_SIZE + 2 * BORDER_SIZE, vacmans.getBoard().getHeight() * CELL_SIZE + 2 * BORDER_SIZE + CONSOLE_HEIGHT + SUMMARY_HEIGHT));
		setMinimumSize(new Dimension(vacmans.getBoard().getWidth() * CELL_SIZE + 2 * BORDER_SIZE, vacmans.getBoard().getHeight() * CELL_SIZE + 2 * BORDER_SIZE + CONSOLE_HEIGHT + SUMMARY_HEIGHT));
		setLayout(new BorderLayout());
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		add(new Main(vacmans), BorderLayout.CENTER);
		add(new Console(vacmans), BorderLayout.NORTH);
		add(new Summary(vacmans), BorderLayout.SOUTH);
		
		pack(); 
	}
	
}