package si.lj.uni.fmf.pro2.lectures.vacmans;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

import si.lj.uni.fmf.pro2.lectures.pacmans.BigCoin;
import si.lj.uni.fmf.pro2.lectures.pacmans.Block;
import si.lj.uni.fmf.pro2.lectures.pacmans.Cell;
import si.lj.uni.fmf.pro2.lectures.pacmans.Coin;
import si.lj.uni.fmf.pro2.lectures.pacmans.Empty;
import si.lj.uni.fmf.pro2.lectures.pacmans.Pacman;
import si.lj.uni.fmf.pro2.lectures.pacmans.Position;
import si.lj.uni.fmf.pro2.lectures.pacmans.SmallCoin;
import si.lj.uni.fmf.pro2.lectures.pacmans.TinyCoin;

public class Main extends JPanel {
	
	private static final long serialVersionUID = 1L;
	
	private Vacmans vacmans;

	public Main(Vacmans vacmans) {
		super();
		
		this.vacmans = vacmans;
		
		setFocusable(true);
		setBackground(new Color(246, 246, 246));
		setBorder(BorderFactory.createLineBorder(Color.BLACK));
		
		addKeyListener(new KeyListener() {

			@Override
			public void keyTyped(KeyEvent e) {
				
			}

			@Override
			public void keyPressed(KeyEvent e) {
				if (e.getKeyCode() == KeyEvent.VK_SPACE) {
					vacmans.setRunning(!vacmans.isRunning());
					vacmans.getRunButton().setSelected(vacmans.isRunning());
					vacmans.getRunButton().setIcon(vacmans.isRunning()? new ImageIcon("icons/pacman.png"):  new ImageIcon("icons/sacman.png"));
					vacmans.getRunButton().setToolTipText(vacmans.isRunning()? "Stop PAC-MANs":  "Start PAC-MANs");
				}
				else if (e.getKeyCode() == KeyEvent.VK_R) {
					vacmans.setRunning(false);
					vacmans.getRunButton().setSelected(false);
					vacmans.getRunButton().setIcon(new ImageIcon("icons/sacman.png"));
					vacmans.getRunButton().setToolTipText("Start PAC-MANs");
					vacmans.reset();
				}
				else if (e.getKeyCode() == KeyEvent.VK_RIGHT)
					vacmans.getSpeedSlider().setValue(vacmans.getSpeedSlider().getValue() + 10);
				else if (e.getKeyCode() == KeyEvent.VK_LEFT)
					vacmans.getSpeedSlider().setValue(vacmans.getSpeedSlider().getValue() - 10);
				else if (e.getKeyCode() == KeyEvent.VK_P)
					for (Pacman pacman: vacmans.getPacmans())
						pacman.setPrime(Math.random() < 0.5);
				
				vacmans.getGUI().repaint();
			}

			@Override
			public void keyReleased(KeyEvent e) {
				
			}
			
		});
		
		addMouseListener(new MouseListener() {
			
			@Override
			public void mouseReleased(MouseEvent e) {
				
			}
			
			@Override
			public void mousePressed(MouseEvent e) {
				
			}
			
			@Override
			public void mouseExited(MouseEvent e) {
				
			}
			
			@Override
			public void mouseEntered(MouseEvent e) {
				
			}
			
			@Override
			public void mouseClicked(MouseEvent e) {
				double width = (getWidth() - 2.0 * GUI.BORDER_SIZE) / vacmans.getBoard().getWidth();
				double height = (getHeight() - 2.0 * GUI.BORDER_SIZE) / vacmans.getBoard().getHeight();
				
				if (!vacmans.getBoard().isEmpty() && e.getX() >= GUI.BORDER_SIZE && e.getY() >= GUI.BORDER_SIZE && e.getX() < getWidth() - GUI.BORDER_SIZE && e.getY() < getHeight() - GUI.BORDER_SIZE) {
					Position position = new Position((int)((e.getX() - GUI.BORDER_SIZE) / width), (int)((e.getY() - GUI.BORDER_SIZE) / height));
					
					if (vacmans.getBoard().getCell(position) instanceof Empty) { 
						Cell cell;
						while ((cell = Cell.random(position)) instanceof Empty);
						
						vacmans.getBoard().setCell(position, cell);
					}
					else if (!(vacmans.getBoard().getCell(position) instanceof Pacman))
						vacmans.getBoard().setCell(position, new Empty(position));
						
					repaint();
				}
			}
			
		});
	}

	@Override
	public void paint(Graphics g) {
		super.paint(g);
		
		Graphics2D graphics = (Graphics2D)g;
		
		double width = (getWidth() - 2.0 * GUI.BORDER_SIZE) / vacmans.getBoard().getWidth();
		double height = (getHeight() - 2.0 * GUI.BORDER_SIZE) / vacmans.getBoard().getHeight();
		
		for (int i = 0; i < vacmans.getBoard().getWidth(); i++) 
			for (int j = 0; j < vacmans.getBoard().getHeight(); j++) {
				Cell cell = vacmans.getBoard().getCell(new Position(i, j));
				if (cell instanceof Block) {
					graphics.setColor(new Color(200, 200, 200));
					graphics.setStroke(new BasicStroke(1.0f));
					
					graphics.fillRect(GUI.BORDER_SIZE + (int)Math.round(i * width), GUI.BORDER_SIZE + (int)Math.round(j * height), (int)Math.round(width), (int)Math.round(height));
				}
				else if (cell instanceof Coin) {
					if (cell instanceof BigCoin)
						graphics.setColor(new Color(214, 175, 54));
					else if (cell instanceof SmallCoin)
						graphics.setColor(new Color(167, 167, 173));
					else if (cell instanceof TinyCoin)
						graphics.setColor(new Color(167, 112, 68));
					graphics.setStroke(new BasicStroke(1.0f));
					
					graphics.fillOval(GUI.BORDER_SIZE + (int)Math.round(i * width) + GUI.INDENT_SIZE, GUI.BORDER_SIZE + (int)Math.round(j * height) + GUI.INDENT_SIZE, (int)Math.round(width) - 2 * GUI.INDENT_SIZE, (int)Math.round(height) - 2 * GUI.INDENT_SIZE);
					
					graphics.setColor(Color.BLACK);
					graphics.setStroke(new BasicStroke(1.5f));
					
					graphics.drawOval(GUI.BORDER_SIZE + (int)Math.round(i * width) + GUI.INDENT_SIZE, GUI.BORDER_SIZE + (int)Math.round(j * height) + GUI.INDENT_SIZE, (int)Math.round(width) - 2 * GUI.INDENT_SIZE, (int)Math.round(height) - 2 * GUI.INDENT_SIZE);
					
					graphics.setColor(Color.BLACK);
					graphics.setStroke(new BasicStroke(1.0f));
					graphics.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 9));
					FontMetrics metrics = graphics.getFontMetrics();
					
					String value = "" + cell.getValue();
					graphics.drawString(value, GUI.BORDER_SIZE + (int)Math.round(i * width + 0.5 * width - 0.5 * metrics.stringWidth(value)), GUI.BORDER_SIZE + (int)Math.round(j * height + 0.5 * height + 0.33 * metrics.getHeight()));
				}
				else if (cell instanceof Pacman) {
					graphics.setColor(new Color(33, 46, 64));
					graphics.setStroke(new BasicStroke(1.5f));
					
					graphics.fillArc(GUI.BORDER_SIZE + (int)Math.round(i * width) + GUI.INDENT_SIZE / 2, GUI.BORDER_SIZE + (int)Math.round(j * height) + GUI.INDENT_SIZE / 2, (int)Math.round(width) - GUI.INDENT_SIZE, (int)Math.round(height) - GUI.INDENT_SIZE, 15, 320);
					
					if (((Pacman)cell).isPrime())
						graphics.setColor(new Color(214, 175, 54));
					else
						graphics.setColor(Color.WHITE);
					graphics.setStroke(new BasicStroke(1.0f));
					
					graphics.fillOval(GUI.BORDER_SIZE + (int)Math.round(i * width + 0.4 * width) + GUI.INDENT_SIZE / 2, GUI.BORDER_SIZE + (int)Math.round(j * height + 0.1 * height) + GUI.INDENT_SIZE / 2, GUI.INDENT_SIZE, GUI.INDENT_SIZE);
					
					graphics.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 10));
					FontMetrics metrics = graphics.getFontMetrics();
					
					String label = "" + cell.getLabel();
					graphics.drawString(label, GUI.BORDER_SIZE + (int)Math.round(i * width + 0.33 * width - 0.5 * metrics.stringWidth(label)), GUI.BORDER_SIZE + (int)Math.round(j * height + 0.5 * height + 0.33 * metrics.getHeight()));
				}
			}
		
		graphics.setColor(Color.BLACK);
		graphics.setStroke(new BasicStroke(1.5f));
		for (int i = 0; i <= vacmans.getBoard().getWidth(); i++)
			graphics.drawLine(GUI.BORDER_SIZE + (int)Math.round(i * width), GUI.BORDER_SIZE, GUI.BORDER_SIZE + (int)Math.round(i * width), getHeight() - GUI.BORDER_SIZE);
		for (int j = 0; j <= vacmans.getBoard().getHeight(); j++)
			graphics.drawLine(GUI.BORDER_SIZE, GUI.BORDER_SIZE + (int)Math.round(j * height), getWidth() - GUI.BORDER_SIZE, GUI.BORDER_SIZE + (int)Math.round(j * height));
		
		if (vacmans.getBoard().isEmpty()) {
			graphics.setColor(new Color(200, 200, 200, 200));
			graphics.fillRect(0, 0, getWidth(), getHeight());
			
			graphics.setStroke(new BasicStroke(1.0f));
			graphics.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 32));
			FontMetrics metrics = graphics.getFontMetrics();
			
			RoundRectangle2D rectangle = new RoundRectangle2D.Float((getWidth() - metrics.stringWidth("Empty board! Reset?")) / 2 - GUI.BORDER_SIZE, getHeight() / 2 - GUI.BORDER_SIZE, metrics.stringWidth("Empty board! Reset?") + 2 * GUI.BORDER_SIZE, metrics.getHeight() + GUI.BORDER_SIZE, 10, 10);
			
			graphics.setColor(new Color(246, 246, 246));
			
	        graphics.fill(rectangle);
			
	        graphics.setColor(Color.BLACK);
	        
	        graphics.draw(rectangle);
			
			graphics.drawString("Empty board! Reset?", (getWidth() - metrics.stringWidth("Empty board! Reset?")) / 2, getHeight() / 2 + 3 * metrics.getHeight() / 5);
		}
	}

	public Vacmans getPacmans() {
		return vacmans;
	}

}