package si.lj.uni.fmf.pro2.lectures.vacmans;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;

import javax.swing.JPanel;

import si.lj.uni.fmf.pro2.lectures.pacmans.BigCoin;
import si.lj.uni.fmf.pro2.lectures.pacmans.SmallCoin;
import si.lj.uni.fmf.pro2.lectures.pacmans.TinyCoin;

public class Summary extends JPanel {
	
	private static final long serialVersionUID = 1L;
	
	private Vacmans vacmans;

	public Summary(Vacmans vacmans) {
		super();
		
		this.vacmans = vacmans;
		
		setFocusable(false);
		setPreferredSize(new Dimension(getWidth(), GUI.SUMMARY_HEIGHT));
	}

	@Override
	public void paint(Graphics g) {
		super.paint(g);
		
		Graphics2D graphics = (Graphics2D)g;

		RoundRectangle2D rectangle = new RoundRectangle2D.Float((int)Math.round(0.325 * getWidth()), GUI.BORDER_SIZE, (int)Math.round(0.35 * getWidth()), getHeight() - 2 * GUI.BORDER_SIZE, 10, 10);
		
		graphics.setColor(new Color(246, 246, 246));
		
        graphics.fill(rectangle);
		
        graphics.setColor(Color.BLACK);
        
        graphics.draw(rectangle);
        
		graphics.setColor(Color.BLACK);
		graphics.setStroke(new BasicStroke(1.0f));
		
		graphics.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 12));
		FontMetrics metrics = graphics.getFontMetrics();
		
		int y = (getHeight() - 4 * metrics.getHeight()) / 2 + 3 * metrics.getHeight() / 4;
		
		if (!vacmans.getBoard().isEmpty())
			graphics.drawString("Board value: ", (int)Math.round(0.425 * getWidth()) - metrics.stringWidth("Board value: "), y);
		else
			graphics.drawString("Empty board!        ", (int)Math.round(0.425 * getWidth()) - metrics.stringWidth("Empty board!        ") / 2, y);
		graphics.drawString("Golden coins: ", (int)Math.round(0.425 * getWidth()) - metrics.stringWidth("Golden coins: "), y + metrics.getHeight());
		graphics.drawString("Silver coins: ", (int)Math.round(0.425 * getWidth()) - metrics.stringWidth("Silver coins: "), y + 2 * metrics.getHeight());
		graphics.drawString("Bronze coins: ", (int)Math.round(0.425 * getWidth()) - metrics.stringWidth("Bronze coins: "), y + 3 * metrics.getHeight());
		
		for (int i = 0; i < Math.min(4, vacmans.getPacmans().size()); i++) {
			String number = i == 0? "1st": i == 1? "2nd": i == 2? "3rd" : "4th";
			graphics.drawString(number + " place: ", (int)Math.round(0.575 * getWidth()) - metrics.stringWidth(number + " place: "), y + i * metrics.getHeight());
		}
		
		graphics.setFont(new Font(Font.SANS_SERIF, Font.PLAIN, 12));
		metrics = graphics.getFontMetrics();
		
		if (!vacmans.getBoard().isEmpty())
			graphics.drawString(vacmans.getBoard().getValue() > 0? String.format("%,d €", vacmans.getBoard().getValue()): "empty", (int)Math.round(0.425 * getWidth()), y);
		graphics.drawString(String.format("%,d of %,d €", vacmans.getBoard().getCount(new BigCoin(null).getClass()), new BigCoin(null).getValue()), (int)Math.round(0.425 * getWidth()), y + metrics.getHeight());
		graphics.drawString(String.format("%,d of %,d €", vacmans.getBoard().getCount(new SmallCoin(null).getClass()), new SmallCoin(null).getValue()), (int)Math.round(0.425 * getWidth()), y + 2 * metrics.getHeight());
		graphics.drawString(String.format("%,d of %,d €", vacmans.getBoard().getCount(new TinyCoin(null).getClass()), new TinyCoin(null).getValue()), (int)Math.round(0.425 * getWidth()), y + 3 * metrics.getHeight());

		for (int i = 0; i < Math.min(4, vacmans.getPacmans().size()); i++) 
			graphics.drawString(String.format("%s with %,.0f €", vacmans.getPacmans().get(i).getLabel() + (vacmans.getPacmans().get(i).isPrime()? "'": ""), vacmans.getScores().get(vacmans.getPacmans().get(i))), (int)Math.round(0.575 * getWidth()), y + i * metrics.getHeight());
	}

	public Vacmans getVacmans() {
		return vacmans;
	}

}