package si.lj.uni.fmf.pro2.lectures.vacmans;

import javax.swing.JSlider;
import javax.swing.JToggleButton;

import si.lj.uni.fmf.pro2.lectures.pacmans.Pacmans;

public class Vacmans extends Pacmans {
	
	private GUI GUI;
	
	private long sleep;
	
	private boolean running;
	
	private JToggleButton runButton;
	
	private JSlider speedSlider;
	
	public Vacmans(int size, int number) {
		this(size, size, number);
	}
	
	public Vacmans(int width, int height, int number) {
		super(width, height, number);
		
		sleep = Pacmans.MOVE_SLEEP_TIME;
		running = false;
		
		runButton = new JToggleButton();
		speedSlider = new JSlider((int)Pacmans.MOVE_SLEEP_TIME / 2, 500, 500 - (int)sleep);
		
		GUI = new GUI(this);
		GUI.setVisible(true);
	}
	
	public GUI getGUI() {
		return GUI;
	}

	public long getSleep() {
		return sleep;
	}

	public void setSleep(long sleep) {
		this.sleep = sleep;
	}

	public boolean isRunning() {
		return running;
	}

	public void setRunning(boolean running) {
		this.running = running;
	}

	public JToggleButton getRunButton() {
		return runButton;
	}

	public JSlider getSpeedSlider() {
		return speedSlider;
	}

	@Override
	protected void draw() {
		/* super.draw(); */
		
		GUI.repaint();
	}

	@Override
	public void play() throws InterruptedException {
		draw();

		while (true) {
			if (isRunning()) {
				setPlays(getPlays() + 1);

				Thread.sleep(PLAY_SLEEP_TIME);

				while (getBoard().hasValue()) {
					if (isRunning()) {
						setRuns(getRuns() + 1);

						move();
					}

					draw();

					Thread.sleep(sleep);
				}
			
				Thread.sleep(PLAY_SLEEP_TIME);
				
				update();
				draw();
			}
			
			Thread.sleep(100);
		}
	}

	public static void main(String[] args) {
		int width = args.length > 0? Integer.parseInt(args[0]): 42;
		int height = args.length > 1? Integer.parseInt(args[1]): 24;
		int number = args.length > 2? Integer.parseInt(args[2]): 7;
		
		Vacmans vacmans = new Vacmans(width, height, number);
		
		try {
			vacmans.play();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
}
