function risi_kroznici(T)
% risi_kroznici(T) narise trikotnik ter vcrtano in ocrtano kroznico
% skupaj s srediscema.
% Trikotnik T je podan kot matrika 3x2 tock,
% T= [ x1 y1; x2 y2; x3 y2]

clf;
hold on;

%narisemo oglisca
plot(T(:,1),T(:,2),'or');

%narisemo poligon
TT=[T;T(1,:)];
plot(TT(:,1),TT(:,2),'r','Linewidth',1);

%narisemo ocrtano in vcrtano kroznico
[So,ro]=ocrtana_kroznica(T);
[Sv,rv]=vcrtana_kroznica(T);
fi=linspace(0,2*pi,360);

xo=ro*cos(fi)+So(1);
yo=ro*sin(fi)+So(2);
plot(xo,yo,'g','Linewidth',1);

xv=rv*cos(fi)+Sv(1);
yv=rv*sin(fi)+Sv(2);
plot(xv,yv,'b','Linewidth',1);

%narisemo sredisci obeh kroznic
plot(So(1),So(2),'xg');
plot(Sv(1),Sv(2),'xb');
axis equal;
hold off;
end


